<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class MissionSeeder extends Seeder
{
    public function run(): void
    {
        // Bersihkan tabel dulu agar id reset (opsional tapi bagus untuk dev)
        // DB::table('missions')->truncate();

        DB::table('missions')->insert([
            [
                'id' => 1,
                'title' => 'Misi 1: Kunjungi Perpustakaan',
                'description' => 'Temukan marker AR di depan perpustakaan dan scan untuk mempelajari sejarahnya.',
                'target_image_name' => 'Image1', // Sesuaikan dengan nama Target di Unity
                'points_reward' => 100,
                'badge_reward_id' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id' => 2,
                'title' => 'Misi 2: Sapa Gedung Utama',
                'description' => 'Cari tahu fakta menarik tentang Gedung Utama dengan scan marker di dekat pintu masuk.',
                'target_image_name' => 'Image2', // Sesuaikan dengan nama Target di Unity
                'points_reward' => 50,
                'badge_reward_id' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'id' => 3,
                'title' => 'Misi 3: Kuis Kilat Aula',
                'description' => 'Jawab kuis singkat tentang fasilitas Aula.',
                'target_image_name' => 'Image3', // Sesuaikan dengan nama Target di Unity
                'points_reward' => 25,
                'badge_reward_id' => null,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}