{{-- resources/views/admin/missions/edit.blade.php --}}
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Misi</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f3f4f6;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }

        .form-label {
            font-weight: 500;
            color: #495057;
            margin-bottom: 0.5rem;
        }

        .input-group > .input-group-text {
            background-color: #fff;
            border: 1px solid #ced4da;
            border-right: none;
            color: #6c757d;
        }

        .input-group > .form-control, .input-group > .form-select {
            border: 1px solid #ced4da;
            border-left: none;
            padding: 0.6rem 1rem;
        }

        .input-group > .form-control:focus {
            box-shadow: none;
            border-color: #86b7fe;
            border-left: 1px solid #86b7fe; /* Visual trick for focus */
        }
    </style>
</head>

<body>
    @include('admin.partials.navbar')

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">

                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h3 class="fw-bold text-dark mb-1">Edit Misi</h3>
                        <p class="text-muted small mb-0">Perbarui informasi untuk misi: <strong>{{ $mission->title }}</strong></p>
                    </div>
                    <a href="{{ route('admin.missions.index') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Kembali
                    </a>
                </div>

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
                        <div class="d-flex">
                            <i class="fas fa-exclamation-triangle mt-1 me-3"></i>
                            <div>
                                <strong>Gagal Memperbarui!</strong>
                                <ul class="mb-0 mt-1 ps-3">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <div class="card p-4">
                    <div class="card-body">
                        <form action="{{ route('admin.missions.update', $mission->id) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <div class="mb-4">
                                <label for="title" class="form-label">Judul Misi <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-heading"></i></span>
                                    <input type="text" name="title" value="{{ old('title', $mission->title) }}" class="form-control" placeholder="Judul Misi" required>
                                </div>
                            </div>

                            <div class="mb-4">
                                <label for="description" class="form-label">Deskripsi Misi</label>
                                <textarea class="form-control border rounded" style="height:120px" name="description" placeholder="Deskripsi">{{ old('description', $mission->description) }}</textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label for="points_reward" class="form-label">Poin Hadiah <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="fas fa-star text-warning"></i></span>
                                        <input type="number" name="points_reward" value="{{ old('points_reward', $mission->points_reward) }}" class="form-control" placeholder="0" min="0" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label for="badge_reward_id" class="form-label">Hadiah Lencana (Opsional)</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="fas fa-medal text-info"></i></span>
                                        <select name="badge_reward_id" class="form-select">
                                            <option value="">-- Tidak Ada --</option>
                                            @foreach ($badges as $badge)
                                                <option value="{{ $badge->id }}"
                                                    {{ (old('badge_reward_id', $mission->badge_reward_id) == $badge->id) ? 'selected' : '' }}>
                                                    {{ $badge->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <hr class="my-4">

                            <div class="d-flex justify-content-end gap-2">
                                <a href="{{ route('admin.missions.index') }}" class="btn btn-light px-4">Batal</a>
                                <button type="submit" class="btn btn-primary px-4 shadow-sm">
                                    <i class="fas fa-save me-2"></i>Simpan Perubahan
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
