<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Misi</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f3f4f6;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }

        .table thead th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #6c757d;
            text-transform: uppercase;
            font-size: 0.8rem;
            letter-spacing: 0.5px;
            border-bottom: 2px solid #e9ecef;
            padding-top: 1rem;
            padding-bottom: 1rem;
        }

        .mission-icon {
            width: 40px;
            height: 40px;
            background-color: #e0f2fe;
            color: #0ea5e9;
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            margin-right: 15px;
        }

        .btn-action {
            width: 35px;
            height: 35px;
            padding: 0;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: all 0.2s;
        }

        .btn-action:hover {
            transform: translateY(-2px);
        }

        .table-hover tbody tr:hover {
            background-color: #fdfdfd;
        }

        .badge-soft-warning {
            background-color: rgba(255, 193, 7, 0.15);
            color: #856404;
        }

        .badge-soft-purple {
            background-color: rgba(111, 66, 193, 0.15);
            color: #6f42c1;
        }
    </style>
</head>

<body>
    <?php echo $__env->make('admin.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container py-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="fw-bold text-dark mb-1">Manajemen Misi</h3>
                <p class="text-muted small mb-0">Atur daftar misi, poin, dan hadiah untuk mahasiswa.</p>
            </div>
            <a href="<?php echo e(route('admin.missions.create')); ?>" class="btn btn-primary shadow-sm rounded-3 px-4">
                <i class="fas fa-plus me-2"></i>Tambah Misi
            </a>
        </div>

        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success alert-dismissible fade show border-0 shadow-sm mb-4" role="alert">
                <i class="fas fa-check-circle me-2"></i> <?php echo e($message); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card overflow-hidden">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th scope="col" class="ps-4" width="50">No</th>
                                <th scope="col">Judul Misi</th>
                                <th scope="col">Reward Poin</th>
                                <th scope="col">Hadiah Lencana</th>
                                <th scope="col" class="text-end pe-4" width="150">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $missions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="ps-4 fw-bold text-muted"><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="mission-icon">
                                                <i class="fas fa-bullseye"></i>
                                            </div>
                                            <div>
                                                <div class="fw-bold text-dark"><?php echo e($mission->title); ?></div>
                                                <small class="text-muted">ID: #<?php echo e($mission->id); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge badge-soft-warning px-3 py-2 rounded-pill">
                                            <i class="fas fa-star me-1"></i> <?php echo e($mission->points_reward); ?> Pts
                                        </span>
                                    </td>
                                    <td>
                                        <?php if($mission->badge): ?>
                                            <span class="badge badge-soft-purple px-3 py-2 rounded-pill">
                                                <i class="fas fa-medal me-1"></i> <?php echo e($mission->badge->name); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted small fst-italic">
                                                <i class="fas fa-minus-circle me-1"></i> Tidak ada
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end pe-4">
                                        <div class="d-flex justify-content-end gap-2">
                                            <a href="<?php echo e(route('admin.missions.edit', $mission->id)); ?>"
                                               class="btn btn-action btn-outline-info"
                                               title="Edit Misi">
                                                <i class="fas fa-pencil-alt small"></i>
                                            </a>

                                            <form action="<?php echo e(route('admin.missions.destroy', $mission->id)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit"
                                                        class="btn btn-action btn-outline-danger"
                                                        onclick="return confirm('Apakah Anda yakin ingin menghapus misi &quot;<?php echo e($mission->title); ?>&quot;? Data yang dihapus tidak dapat dikembalikan.')"
                                                        title="Hapus Misi">
                                                    <i class="fas fa-trash-alt small"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center py-5">
                                        <div class="text-muted">
                                            <i class="fas fa-clipboard-list fa-3x mb-3 opacity-50"></i>
                                            <p class="mb-0">Belum ada misi yang ditambahkan.</p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php if($missions->hasPages()): ?>
                <div class="card-footer bg-white py-3 border-0">
                    <div class="d-flex justify-content-center">
                        <?php echo $missions->links(); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php /**PATH /Users/smc/Desktop/laravel_api/polbeng-ar-gamifikasi/resources/views/admin/missions/index.blade.php ENDPATH**/ ?>