
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Misi Baru</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f3f4f6;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }

        .form-label {
            font-weight: 500;
            color: #495057;
            margin-bottom: 0.5rem;
        }

        .input-group-text {
            background-color: #fff;
            border-right: none;
            color: #6c757d;
        }

        .form-control,
        .form-select {
            border-left: none;
            padding: 0.6rem 1rem;
        }

        .form-control:focus,
        .form-select:focus {
            box-shadow: none;
            border-color: #ced4da;
            /* Optional: change highlight color */
        }

        /* Hack to make border look connected despite removing left border */
        .input-group .form-control:focus {
            border-color: #86b7fe;
            z-index: 3;
        }

        .input-group-text+.form-control,
        .input-group-text+.form-select {
            border-left: 1px solid #ced4da;
            /* Restore border for separation if preferred, or keep seamless */
            border-left: none;
        }

        /* Fix border visual */
        .input-group>.form-control,
        .input-group>.form-select {
            border: 1px solid #ced4da;
            border-left: none;
        }

        .input-group>.input-group-text {
            border: 1px solid #ced4da;
            border-right: none;
        }
    </style>
</head>

<body>
    <?php echo $__env->make('admin.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">

                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h3 class="fw-bold text-dark mb-1">Tambah Misi Baru</h3>
                        <p class="text-muted small mb-0">Isi formulir di bawah untuk membuat misi baru bagi mahasiswa.
                        </p>
                    </div>
                    <a href="<?php echo e(route('admin.missions.index')); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-arrow-left me-1"></i> Kembali
                    </a>
                </div>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show shadow-sm border-0 mb-4" role="alert">
                        <div class="d-flex">
                            <i class="fas fa-exclamation-triangle mt-1 me-3"></i>
                            <div>
                                <strong>Terjadi Kesalahan!</strong>
                                <ul class="mb-0 mt-1 ps-3">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="card p-4">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.missions.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="mb-4">
                                <label for="title" class="form-label">Judul Misi <span
                                        class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-heading"></i></span>
                                    <input type="text" name="title" class="form-control"
                                        placeholder="Contoh: Menyelesaikan Modul 1" required>
                                </div>
                                <div class="form-text text-muted">Berikan judul yang singkat dan jelas.</div>
                            </div>

                            <div class="mb-4">
                                <label for="target_image_name" class="form-label">Nama Target Vuforia (Unity) <span
                                        class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-cube"></i></span>
                                    <input type="text" name="target_image_name" class="form-control"
                                        placeholder="Contoh: Image1" required>
                                </div>
                                <div class="form-text text-muted text-danger">
                                    <strong>PENTING:</strong> Harus SAMA PERSIS dengan nama GameObject Image Target di
                                    Hierarchy Unity (Case Sensitive).
                                </div>
                            </div>

                            <div class="mb-4">
                                <label for="description" class="form-label">Deskripsi Misi</label>
                                <textarea class="form-control border rounded" style="height:120px" name="description"
                                    placeholder="Jelaskan detail apa yang harus dilakukan mahasiswa..."></textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label for="points_reward" class="form-label">Poin Hadiah <span
                                            class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="fas fa-star text-warning"></i></span>
                                        <input type="number" name="points_reward" class="form-control" placeholder="0"
                                            min="0" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label for="badge_reward_id" class="form-label">Hadiah Lencana (Opsional)</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="fas fa-medal text-info"></i></span>
                                        <select name="badge_reward_id" class="form-select">
                                            <option value="">-- Pilih Lencana --</option>
                                            <?php $__currentLoopData = $badges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $badge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($badge->id); ?>"><?php echo e($badge->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <hr class="my-4">

                            <div class="d-flex justify-content-end gap-2">
                                <a href="<?php echo e(route('admin.missions.index')); ?>" class="btn btn-light px-4">Batal</a>
                                <button type="submit" class="btn btn-primary px-4 shadow-sm">
                                    <i class="fas fa-save me-2"></i>Simpan Misi
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php /**PATH /Users/smc/Desktop/laravel_api/polbeng-ar-gamifikasi/resources/views/admin/missions/create.blade.php ENDPATH**/ ?>