
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Manajemen Lokasi AR</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <?php echo $__env->make('admin.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3>Manajemen Lokasi AR</h3>
            <a href="<?php echo e(route('admin.locations.create')); ?>" class="btn btn-primary">Tambah Lokasi Baru</a>
        </div>
        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success"><?php echo e($message); ?></div>
        <?php endif; ?>
        <div class="card">
            <div class="card-body">
                <table class="table table-bordered">
                    <tr>
                        <th>No</th>
                        <th>Nama Lokasi</th>
                        <th>ID Marker</th>
                        <th width="280px">Aksi</th>
                    </tr>
                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($location->name); ?></td>
                            <td><?php echo e($location->marker_id); ?></td>
                            <td>
                                <form action="<?php echo e(route('admin.locations.destroy', $location->id)); ?>" method="POST">
                                    <a class="btn btn-info btn-sm"
                                        href="<?php echo e(route('admin.locations.edit', $location->id)); ?>">Edit</a>
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm"
                                        onclick="return confirm('Yakin ingin menghapus?')">Hapus</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
                <?php echo $locations->links(); ?>

            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /Users/smc/Desktop/laravel_api/polbeng-ar-gamifikasi/resources/views/admin/locations/index.blade.php ENDPATH**/ ?>